# LiveStreamer

Live STANAG 4609 re-streamer utility

**LiveStreamer** utility provides STANAG file recasting services.
You can emulate live STANAG streaming to udp unicast / multicast or file targets. File can be streamed in loop (video ant TS timestamps are restamped to fully simulate live streaming).

> As MPEG format uses 33 bit for the **PTS** timestamps, they will eventually (2^33 / 90000 kHz = about 26.5 hours) come to wraparound for the continues sources. If you use a file instead of live streaming, simply sending it as is, this will happen after every loop. Many applications rely on continuously increasing timestamps, for example, **DVR** timestamp based seeking may only handle a natural wraparounds - one wrap without introducing any additional inconsistencies. If a stream has many sudden changes to its timeline, the timestamp based seeking won't work. **LiveStreamer** ensures that the looped content will have it's timestamps fixed.

Available for Windows and Linux.

There are 2 modes of operation:

- Video pass through
- Info overlay

### Video pass through
Original video and data pids are remultiplexed (no video transcoding).

### Info overlay

![liveStreamer overlay](./images/video.jpg)

Video is transcoded and overlaid with some info useful for testing. Note, this mode requires more PC resources (depending on resolution and encoding presets) and video quality will of course degrade (generation loss).

Video overlay shows the following info:

- Date / Time
- Video PTS in seconds (PTS wraparounds are taken into account, so it is an *accumulated time*)
- Frame count  
Video resolution, bitrate and profile are taken from the source file. It is possible to override the bitrate and profile.

## Usage

![liveStreamer cmd](./images/cmd.png)

Basic demo usage. Unicast streaming:
```
liveStreamer -i C:/Movie/stanagFile.ts -o udp://192.168.1.26:30122
```

Basic demo usage. Multicast streaming:
```
liveStreamer -i C:/Movie/stanagFile.ts -o udp://227.1.1.1:30122
```
>Note. You can select specific output network interface (add **localaddr=**) and packet (add **pkt_size=**) size for streaming. For example:

```
liveStreamer -i C:/Movie/stanagFile.ts -o "udp://227.1.1.1:30122?localaddr=192.168.1.28&pkt_size=1316"
```

Running with license (as arguments), infinite loop:
```
liveStreamer -i C:/Movie/stanagFile.ts -o udp://227.1.1.1:30122 --licenseFile "C:/Doc/MyLicense.lic" --licenseKey 8CFE4E49-ABDE1B14-159A70E4-BDFF67AB
```
> Note, you can just copy the license files to the current directory.

Loop file 5 times.
```
liveStreamer -i C:/Movie/stanagFile.ts -o udp://227.1.1.1:30122 -l 4
```

Overlaying time, pts and frame count.
```
liveStreamer -i C:/Movie/stanagFile.ts -o udp://227.1.1.1:30122 --overlay true
```

Saving to file:
```
liveStreamer -i C:/Movie/stanagFile.ts -o c:/tmp/file.ts
```

### Options

| Flag     |      Name           | Description 								        	|
|:---------|:--------------------|:-----------------------------------------------------|
| -i       |  --input            | Input File path                                      |
| -o       |  --output           | Output url                                           |
| -l       |  --loop             | Loop. Number of times the file shall be looped. Loop 0 means no loop, -1 (default) infinite |
|          |  --serviceName      | Custom service name. Default - Live                 |
|          |  --overlay          | Overlay info (true / false). Note, this will transcode the video    |
| -c       |  --color            | Overlay color.       	      		                |
|          |  --vb               | Video bitrate. If not set, the original bitrate will be used for transcoding'          |
|          |  --preset           | Encoding preset (ultrafast, superfast, veryfast, faster, fast, medium, slow, slower, veryslow).  Default - ultrafast.   |
|          |  --profile          | Profile. baseline, main, high. Default - original file profile, if supported, or 'Main'   |
|          |  --licenseFile      | License file                                 |
|          |  --licenseKey       | License Key          	      		        |
|          |  --printUsage       | Print args description (true/false)          |


#### UDP output options

Additionally, you can add arguments to the **output udp url**.  
Options contain a list of &-separated options of the form key=val. Use **?** before the first one.

The list of supported options:

**buffer_size=size**  
Set the UDP maximum socket buffer size in bytes. Default is 32 KB for output.

**bitrate=bitrate**  
If set to nonzero, the output will have the specified constant bitrate if the input has enough packets to sustain it.

**burst_bits=bits**  
When using bitrate this specifies the maximum number of bits in packet bursts.

**localport=port**  
Override the local UDP port to bind with.

**localaddr=addr**  
Local IP address of a network interface used for sending packets or joining multicast groups.

**pkt_size=size**  
Set the size in bytes of UDP packets.

**reuse=1|0**  
Explicitly allow or disallow reusing UDP sockets.

**ttl=ttl**  
Set the time to live value (for multicast only).

**connect=1|0**  
Initialize the UDP socket with connect(). In this case, the destination address can’t be changed with ff_udp_set_remote_url later. If the destination address isn’t known at the start, this option can be specified in ff_udp_set_remote_url, too. This allows finding out the source address for the packets with getsockname, and makes writes return with AVERROR(ECONNREFUSED) if "destination unreachable" is received. 

**broadcast=1|0**
Explicitly allow or disallow UDP broadcasting.

Note that broadcasting may not work properly on networks having a broadcast storm protection.

Sample:
```
udp://hostname:port?pkt_size=188&buffer_size=65535
```

## License

Application without license will work in demo mode (for about 10 min). In order to lift demo restrictions you should provide the license using one of two options:

- passing license info as the arguments (with --licenseFile and --licenseKey)
- copying license file (.lic) and a key (.txt) file into current working directory

IMPLEOTV SYSTEMS LTD, 2020.
